#ifndef TDISPLAY_H
#define TDISPLAY_H

#include <Arduino.h>

class tDisplay {
public:
    tDisplay(uint8_t bit1, uint8_t bit2, uint8_t bit3, uint8_t bit4,
             uint8_t stcp, uint8_t shcp, uint8_t data);

    void begin();
    void displayNumber(float number);
    void displayInt(int number);
    void turnOffAll();
    void clear();
    void update(); // 需要定期在 loop 中调用

private:
    uint8_t _bitPins[4];
    uint8_t _stcpPin;
    uint8_t _shcpPin;
    uint8_t _dataPin;
    int _currentDigits[4] = {0, 0, 0, 0};
    bool _decimalPoints[4] = {false, false, false, false};
    uint8_t _currentPosition = 0;
    unsigned long _lastUpdateTime = 0;
    bool _displayEnabled = true;
    static const uint8_t _digitTable[20];

    void _shiftData(uint8_t data);
    void _displayCurrentDigit();
    void _setDisplayData(float number);
    void _setIntDisplayData(int number);
};

#endif