/**
奇果派Esp32-S3电机驱动板示例代码：RC-6通道手柄控制麦克纳姆轮智能小车
按钮3释放状态：
  摇杆上下：车子前进后退
  摇杆左右：左右转弯或左右横移（受按钮5状态影响）
按钮3按下状态：
  摇杆上下：舵机1+-
  摇杆左右：舵机2+-
按钮4：电子开关
按钮6：引脚7高低电平*/

#include <Arduino.h>
#include <EMotionPI.h>
#include <BLEControlStick.h>
#include "sbus.h"

bfs::SbusRx sbus_rx(&Serial2,17,-1,true,false);
bfs::SbusData data;
bool sbusConnected = false;
int vy, vx;
bool btn_3, btn_4, btn_5, btn_6;

EMotionPI emo;
/**4个电机*/
EMO_DCMotor *enMotor1=emo.getMotor(M1);
EMO_DCMotor *enMotor2=emo.getMotor(M2);
EMO_DCMotor *enMotor3=emo.getMotor(M3);
EMO_DCMotor *enMotor4=emo.getMotor(M4);

/**2个舵机*/
EMO_Servo* servo1=emo.getServo(S1);
EMO_Servo* servo2=emo.getServo(S2);

float cur_speed = 100;            // 手柄遥控速度 0-100
unsigned long last_pstime = 0;    // 手柄最后遥控时间

void setup()
{
  Serial.begin(115200);
  while (!Serial) {}
  sbus_rx.Begin();
  pinMode(7, OUTPUT);
  pinMode(45, OUTPUT);
  Serial.println("setup");
}

void loop()
{
  if (sbus_rx.Read()) {
    data = sbus_rx.data();
    sbusConnected = !data.failsafe;
    if (sbusConnected && !data.lost_frame) {
      vy=map(data.ch[1], 0, 1600, -100, 100);
      vx=map(data.ch[0], 0, 1600, -100, 100);
      btn_3 = (data.ch[2]>192);
      btn_4 = (data.ch[3]>192);
      btn_5 = (data.ch[4]>192);
      btn_6 = (data.ch[5]>192);
      
    }else{
      vy=vx=0;
      btn_3 = btn_4 = btn_5 = btn_6 = false;
    }
  }
  // Serial.printf("[vx]:%d,[vy]:%d, %d,%d,%d\n", vy, vx, btn_3, btn_4, btn_5);
  // return;
  
  if(btn_3 == false)
  {
    //电机
    if(vy!=0 || vx!=0)
        last_pstime = millis();
    int left = vy + vx;
    int right = vy - vx;
    if (btn_5){
      enMotor1->spin(left);
      enMotor2->spin(right);
      enMotor3->spin(right);
      enMotor4->spin(left);
    }else{
      enMotor1->spin(left);
      enMotor2->spin(right);
      enMotor3->spin(left);
      enMotor4->spin(right);
      Serial.println("turn left");
    }
  }else{
    //舵机
    if(vx > 0){
      if(servo1->read() < 180)
        servo1->write(servo1->read()+1);
    }else if(vx < 0){
      if(servo1->read() > 0)
        servo1->write(servo1->read()-1);
    }
  }
  if(btn_4)
    digitalWrite(45, HIGH);
  else
    digitalWrite(45, LOW);

  if(btn_6)
    digitalWrite(7, HIGH);
  else
    digitalWrite(7, LOW);

  if(millis() - last_pstime > 200){
    enMotor1->spin(0);
    enMotor2->spin(0);
    enMotor3->spin(0);
    enMotor4->spin(0);
  }
  delay(5);
}