/**
奇果派Esp32-S3电机驱动板示例代码：陀螺仪示例
1.准备mpu6050陀螺仪模块
2.插入开发板imu接口
实现功能：打印6轴加速度传感器数值
*/

#include <Arduino.h>
#include <math.h>
#include "IMU.h"

MPU6050 mpu(Wire);                // 初始化MPU6050对象
IMU imu(mpu);                     // 初始化IMU对象
imu_t imu_data;

void setup() 
{
  Serial.begin(115200);
  bool imuStatus = imu.begin();
  Serial.println("启动完毕");
}

unsigned long timer = 0;
void loop() 
{
  imu.update();
  if ((millis() - timer) > 50)
  {
    imu.getImuData(imu_data); // 获取IMU数据结构体

    Serial.print(F("加速度     x: "));Serial.print(mpu.getAccX()); 
    Serial.print("\tY: ");Serial.print(mpu.getAccY()); 
    Serial.print("\t Z: ");Serial.println(mpu.getAccZ()); 

    Serial.print(F("角速度     X: "));Serial.print(mpu.getGyroX()); 
    Serial.print("\tY: ");Serial.print(mpu.getGyroY()); 
    Serial.print("\t Z: ");Serial.println(mpu.getGyroZ()); 

    Serial.print(F("角加速度   X: "));Serial.print(mpu.getAccAngleX()); 
    Serial.print("\tY: ");Serial.println(mpu.getAccAngleY()); 

    Serial.print(F("角度       X: "));Serial.print(mpu.getAngleX());
    Serial.print("\tY: ");Serial.print(mpu.getAngleY()); 
    Serial.print("\tZ: ");Serial.println(mpu.getAngleZ()); 
   
    // Serial.printf("imu:\teuler(%f,%f,%f)\n",
    //               imu_data.angle_euler.x, imu_data.angle_euler.y, imu_data.angle_euler.z);
    // Serial.printf("imu:\torientation(%f,%f,%f,%f)\n",
    //               imu_data.orientation.w, imu_data.orientation.x, imu_data.orientation.y, imu_data.orientation.z);

    Serial.println(F("=====================================================\n"));
    timer = millis();
  }

}
