/**
奇果派Esp32-S3电机驱动板示例代码：编码器电机示例
1. 蓝牙手柄控制电机旋转，定时读取电机转速、位置
2. 按手柄A键控制车辆前进一米简单实现
*/

#include <Arduino.h>
#include <EMotionPI.h>
#include <BLEControlStick.h>

BLEControlStick _joy;
EMotionPI emo;

/**编码器电机*/
EMO_EncoderMotor *enMotor1=emo.getEncoderMotor(M1);
EMO_EncoderMotor *enMotor2=emo.getEncoderMotor(M2);
EMO_EncoderMotor *enMotor3=emo.getEncoderMotor(M3);
EMO_EncoderMotor *enMotor4=emo.getEncoderMotor(M4);

float cur_speed = 100;            // 手柄遥控速度 0-100
unsigned long last_pstime = 0;    // 手柄最后遥控时间
unsigned long gp_time = 0;    
bool isMoving = false;
int endPos = 0;                   //行走1米的计算出来的编码器结束位置


/*
***************************************************************************************************
* StickCB类 - 处理蓝牙手柄事件
***************************************************************************************************
*/
class StickCB : public StickCallback
{
private:

public:
  StickCB() {
  }

  void onConnect()
  {
    Serial.printf("onConnect\n");
  }

  void onDisconnect()
  {
    Serial.printf("onDisconnect\n");
  }

  void onStickChanged(const ButtonEvent &event)
  {
    event.button(BTN_A) ? Serial.println("A键按下") : Serial.println("A键未按下");
    Serial.printf("onStickChanged: %d %d %d %d\n", event.getAxisLX(), event.getAxisLY(), event.getAxisRX(), event.getAxisRY());
  }

  void onButton(const ButtonEvent &event)
  {
    if (event.button(BTN_A)) Serial.println("按住A键...");
  }

  void onButtonChanged(const ButtonEvent &event)
  {
    Serial.printf("======onButtonChanged: %d===========\n", event.getButtonState());
  }
  
  void onButtonPressed(const ButtonEvent& event) override {
    // 使用简洁的语法检查按钮
    if (event & BTN_A) Serial.println("按下了A键");
    if (event & BTN_B) Serial.println("按下了B键");
    if (event & BTN_X) Serial.println("按下了X键");
    if (event & BTN_Y) Serial.println("按下了Y键");
    if (event & BTN_L1) Serial.println("按下了L1键");
    if (event & BTN_R1) Serial.println("按下了R1键");
    
    // 或者使用button方法
    if (event.button(BTN_START)) Serial.println("按下了START键");
    if (event.button(BTN_SEL)) Serial.println("按下了SELECT键");
    
    // 方向键检查
    if (event.button(BTN_DPAD_UP)) Serial.println("按下了UP键");
    if (event.button(BTN_DPAD_DOWN)) Serial.println("按下了DOWN键");
    if (event.button(BTN_DPAD_LEFT)) Serial.println("按下了LEFT键");
    if (event.button(BTN_DPAD_RIGHT)) Serial.println("按下了RIGHT键");
}


void onButtonReleased(const ButtonEvent& event) override {
  // 同样可以检查释放的按钮
  if (event & BTN_A) Serial.println("释放了A键");
  // 其他按钮...
}
};

/**刹车
brakeForce：刹车力度*/
void stop(int brakeForce)
{
  enMotor1->brake(brakeForce);
  enMotor2->brake(brakeForce);
  enMotor3->brake(brakeForce);
  enMotor4->brake(brakeForce);
}

void setup() 
{
  Serial.begin(115200);
  // 初始化蓝牙手柄
  _joy.setStickCallback(new StickCB());
  _joy.begin();
  delay(100);
  emo.begin();
  enMotor1->begin(90);  //该电机齿数比是1：90
  enMotor2->begin(90);
  enMotor3->begin(90);
  enMotor4->begin(90);
  Serial.println("启动完毕");
}

void loop() 
{
  _joy.update();
  
  int speed = 0;
  //左侧摇杆控制车子前进后退 
  if (_joy.Analog(BPSS_LY) < 125)
  {
    speed = map(_joy.Analog(BPSS_LY), 125, 0, 30, cur_speed);
    enMotor1->run(FORWARD); enMotor1->setSpeed(speed);
    enMotor2->run(FORWARD); enMotor2->setSpeed(speed);
    enMotor3->run(FORWARD); enMotor3->setSpeed(speed);
    enMotor4->run(FORWARD); enMotor4->setSpeed(speed);
  }else if (_joy.Analog(BPSS_LY) > 130){
    speed = map(_joy.Analog(BPSS_LY), 130, 255, 30, cur_speed);  
    enMotor1->run(BACKWARD); enMotor1->setSpeed(speed);
    enMotor2->run(BACKWARD); enMotor2->setSpeed(speed);
    enMotor3->run(BACKWARD); enMotor3->setSpeed(speed);
    enMotor4->run(BACKWARD); enMotor4->setSpeed(speed);
  }

  if (_joy.Button(BTN_A)){
    //让车子前进一米
    if(isMoving) return;
    isMoving = true;
    endPos = enMotor1->getEncoderPos() + ((1000 /(65*3.14)) * 48 * 90);   //轮子直径65毫米，编码器一圈48个位置，齿数比90（电机转90圈轮子转一圈）
    Serial.printf("endPos=%d\n", endPos);
  }
  
  if(isMoving){
    if(enMotor1->getEncoderPos() < endPos){
      enMotor1->run(FORWARD); enMotor1->setSpeed(70);
      enMotor2->run(FORWARD); enMotor2->setSpeed(70);
      enMotor3->run(FORWARD); enMotor3->setSpeed(70);
      enMotor4->run(FORWARD); enMotor4->setSpeed(70);
      // Serial.printf("前进,当前位置：%d\n", enMotor1->getEncoderPos());
    }else{
      isMoving = false;
      stop(100);
    }
  }

  if(millis() - gp_time > 1000){
    gp_time = millis();
    int rpm = enMotor1->getRPM();
    long pos = enMotor1->getEncoderPos();
    float laps = pos/48;
    Serial.printf("转速: %d/min,",enMotor1->getRPM());
    Serial.printf("位置: %d,",enMotor1->getEncoderPos());
    Serial.printf("第 %0.f圈 \n",laps);
  }

  if(speed > 0)
    last_pstime = millis();

  if(!isMoving && millis() - last_pstime > 100) {    //当一定时间内没有收到任何操作信号，则停车
    stop(50);
  }
}
