/**
奇果派Esp32-S3电机驱动板示例代码：检测电压示例
定时串口输出当前电压值及剩余电量
剩余电量的计算，请根据电池型号更改map函数的参数*/

#include <EMotionPI.h>

EMotionPI emo ;

void setup() 
{
  Serial.begin(115200);
  Serial.println("启动完毕");
}

unsigned long gapsMillis = 0;
void loop() 
{
  if(millis() - gapsMillis > 3000)
  {
    gapsMillis = millis();
    float voltage = emo.readVoltage(); 
    uint8_t voltageRate = static_cast<uint8_t>(map(voltage, 9.1, 12.7, 0, 100));  
    if(voltageRate > 100)
      voltageRate = 100;
    Serial.printf("电压:%.2fV, 剩余电量：%d%%\n", voltage, voltageRate);
  }

}
