/**
奇果派Esp32-S3电机驱动板示例代码：RC-10通道手柄控制麦克纳姆轮智能小车
左侧摇杆：
  摇杆上下：车子前进后退
  摇杆左右：左右转弯
右侧摇杆：
  摇杆上下：最大速度
  摇杆左右：左右横移
旋钮1：舵机1角度
旋钮2：舵机2角度
开关2：电子开关
开关3：7号引脚
开关1和4预留*/

#include <Arduino.h>
#include <EMotionPI.h>
#include <BLEControlStick.h>
#include "sbus.h"

bfs::SbusRx sbus_rx(&Serial2,17,-1,true,false);
bfs::SbusData data;
bool sbusConnected = false;
int vy, vx, vz, s1, s2;
bool btn_2, btn_3;

EMotionPI emo;
BaseChassis* kinematics;
/**4个电机*/
EMO_DCMotor *enMotor1=emo.getMotor(M1);
EMO_DCMotor *enMotor2=emo.getMotor(M2);
EMO_DCMotor *enMotor3=emo.getMotor(M3);
EMO_DCMotor *enMotor4=emo.getMotor(M4);

/**2个舵机*/
EMO_Servo* servo1=emo.getServo(S1);
EMO_Servo* servo2=emo.getServo(S2);

float cur_speed = 100;            // 手柄遥控速度 0-100
unsigned long last_pstime = 0;    // 手柄最后遥控时间

void setup()
{
  Serial.begin(115200);
  while (!Serial) {}
  // 初始化底盘
  kinematics = emo.createBaseChassis(BaseChassis::MECANUM);
  kinematics->setMaxPWM(100);
  kinematics->stop();

  sbus_rx.Begin();
  pinMode(7, OUTPUT);
  pinMode(45, OUTPUT);
  Serial.println("setup");
}

void loop()
{
  if (sbus_rx.Read()) {
    data = sbus_rx.data();
    sbusConnected = !data.failsafe;
    if (sbusConnected && !data.lost_frame) {
      cur_speed=map(data.ch[1], 185, 1785, 0, 100);
      vx=map(data.ch[0], 192, 1792, cur_speed, -cur_speed);
      vy=map(data.ch[2], 192, 1792, -cur_speed, cur_speed);
      vz=map(data.ch[3], 192, 1792, cur_speed, -cur_speed);
      s1=map(data.ch[8], 192, 1792, 0, 180);
      s2=map(data.ch[9], 192, 1792, 0, 180);
      btn_2 = (data.ch[5]>192);
      btn_3 = (data.ch[6]>192);

      
    }else{
      vy=vx=vz=0;
      btn_2 = btn_3 = false;
    }
  }
  
  // Serial.printf("%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n", data.ch[0], data.ch[1], data.ch[2], data.ch[3], data.ch[4], data.ch[5], data.ch[6], data.ch[7], data.ch[8], data.ch[9]);
  // return;
  // Serial.printf("%d,%d,%d\n",vy, vx, vz);
  if(vx!=0 || vy!=0 || vz!=0)
    last_pstime = millis();
  kinematics->updateDuty(vy, vx, vz);
  servo1->write(s1);
  servo2->write(s2);

  if(btn_2)
    digitalWrite(45, HIGH);
  else
    digitalWrite(45, LOW);

  if(btn_3)
    digitalWrite(7, HIGH);
  else
    digitalWrite(7, LOW);

  if(millis() - last_pstime > 200){
    kinematics->updateDuty(0, 0, 0);
  }
  delay(5);
}