/**
奇果派Esp32-S3电机驱动板示例代码：蓝牙手柄控制麦克纳姆轮智能小车
蓝牙手柄控制4电机 4舵机
左侧摇杆：车子前进后退 + 左右横移
右侧摇杆：车子前进后退 + 左右转弯
左侧方向键：上下舵机1  左右舵机2
右侧按钮：YA舵机3 XB舵机4*/

#include <Arduino.h>
//#include "StickCB.h"
#include <EMotionPI.h>
#include <BLEControlStick.h>

BLEControlStick _joy;
EMotionPI emo;

/**4个普通电机*/
EMO_DCMotor *enMotor1=emo.getMotor(M1);
EMO_DCMotor *enMotor2=emo.getMotor(M2);
EMO_DCMotor *enMotor3=emo.getMotor(M3);
EMO_DCMotor *enMotor4=emo.getMotor(M4);

/**4个舵机*/
EMO_Servo* servo1=emo.getServo(S1);
EMO_Servo* servo2=emo.getServo(S2);
EMO_Servo* servo3=emo.getServo(S3);
EMO_Servo* servo4=emo.getServo(S4);

float cur_speed = 100;            // 手柄遥控速度 0-100
unsigned long last_pstime = 0;    // 手柄最后遥控时间

/*
***************************************************************************************************
* StickCB类 - 处理蓝牙手柄事件
***************************************************************************************************
*/
class StickCB : public StickCallback
{
private:

public:
  StickCB() {
  }

  void onConnect()
  {
    Serial.printf("onConnect\n");
  }

  void onDisconnect()
  {
    Serial.printf("onDisconnect\n");
  }

  void onStickChanged(const ButtonEvent &event)
  {
    event.button(BTN_A) ? Serial.println("A键按下") : Serial.println("A键未按下");
    Serial.printf("onStickChanged: %d %d %d %d\n", event.getAxisLX(), event.getAxisLY(), event.getAxisRX(), event.getAxisRY());
  }

  void onButton(const ButtonEvent &event)
  {
    if (event.button(BTN_A)) Serial.println("按住A键...");
  }

  void onButtonChanged(const ButtonEvent &event)
  {
    Serial.printf("======onButtonChanged: %d===========\n", event.getButtonState());
  }
  
  void onButtonPressed(const ButtonEvent& event) override {
    // 使用简洁的语法检查按钮
    if (event & BTN_A) Serial.println("按下了A键");
    if (event & BTN_B) Serial.println("按下了B键");
    if (event & BTN_X) Serial.println("按下了X键");
    if (event & BTN_Y) Serial.println("按下了Y键");
    if (event & BTN_L1) Serial.println("按下了L1键");
    if (event & BTN_R1) Serial.println("按下了R1键");
    
    // 或者使用button方法
    if (event.button(BTN_START)) Serial.println("按下了START键");
    if (event.button(BTN_SEL)) Serial.println("按下了SELECT键");
    
    // 方向键检查
    if (event.button(BTN_DPAD_UP)) Serial.println("按下了UP键");
    if (event.button(BTN_DPAD_DOWN)) Serial.println("按下了DOWN键");
    if (event.button(BTN_DPAD_LEFT)) Serial.println("按下了LEFT键");
    if (event.button(BTN_DPAD_RIGHT)) Serial.println("按下了RIGHT键");
}


void onButtonReleased(const ButtonEvent& event) override {
  // 同样可以检查释放的按钮
  if (event & BTN_A) Serial.println("释放了A键");
  // 其他按钮...
}
};


/**刹车
brakeForce：刹车力度*/
void stop(int brakeForce)
{
  enMotor1->brake(brakeForce);
  enMotor2->brake(brakeForce);
  enMotor3->brake(brakeForce);
  enMotor4->brake(brakeForce);
}

void setup() 
{
  Serial.begin(115200);
  // 初始化蓝牙手柄
  _joy.setStickCallback(new StickCB());
  _joy.begin();
  delay(100);
  servo1->write(90);
  servo2->write(90);
  servo3->write(90);
  servo4->write(90);
  Serial.println("启动完毕");
}

void loop() 
{
  _joy.update();

  //舵机1
  if (_joy.Button(BTN_DPAD_UP))
  {
    if(servo1->read() < 175)
      servo1->write(servo1->read()+1);
  }else if (_joy.Button(BTN_DPAD_DOWN))
  {
    if(servo1->read() > 5)
      servo1->write(servo1->read()-1);
  }
  
  //舵机2
  if (_joy.Button(BTN_DPAD_LEFT))
  {
    if(servo2->read() < 175)
      servo2->write(servo2->read()+1);
  }else if (_joy.Button(BTN_DPAD_RIGHT))
  {
    if(servo2->read() > 5)
      servo2->write(servo2->read()-1);
  }

  //舵机3
  if (_joy.Button(BTN_Y))
  {
    if(servo3->read() < 175)
      servo3->write(servo3->read()+1);
  }else if (_joy.Button(BTN_A))
  {
    if(servo3->read() > 5)
      servo3->write(servo3->read()-1);
  }

  //舵机4
  if (_joy.Button(BTN_X))
  {
    if(servo4->read() < 175)
      servo4->write(servo4->read()+1);
  }else if (_joy.Button(BTN_B))
  {
    if(servo4->read() > 5)
      servo4->write(servo4->read()-1);
  }

  if (_joy.Button(BTN_R2) || _joy.Button(BTN_L2)) // 刹车急停
  {
    stop(100);
    return;
  }
  int speed = 0;
  //左侧摇杆控制车子前进后退 + 左右横移
  if (_joy.Analog(BPSS_LY) < 125)
  {
    speed = map(_joy.Analog(BPSS_LY), 125, 0, 30, cur_speed);
    enMotor1->run(FORWARD); enMotor1->setSpeed(speed);
    enMotor2->run(FORWARD); enMotor2->setSpeed(speed);
    enMotor3->run(FORWARD); enMotor3->setSpeed(speed);
    enMotor4->run(FORWARD); enMotor4->setSpeed(speed);
  }else if (_joy.Analog(BPSS_LY) > 130){
    speed = map(_joy.Analog(BPSS_LY), 130, 255, 30, cur_speed);  
    enMotor1->run(BACKWARD); enMotor1->setSpeed(speed);
    enMotor2->run(BACKWARD); enMotor2->setSpeed(speed);
    enMotor3->run(BACKWARD); enMotor3->setSpeed(speed);
    enMotor4->run(BACKWARD); enMotor4->setSpeed(speed);
  }

  if (_joy.Analog(BPSS_LX) < 125)
  {
    speed = map(_joy.Analog(BPSS_LX), 125, 0, 30, cur_speed);  
    enMotor1->run(BACKWARD); enMotor1->setSpeed(speed);
    enMotor2->run(FORWARD); enMotor2->setSpeed(speed);
    enMotor3->run(FORWARD); enMotor3->setSpeed(speed);
    enMotor4->run(BACKWARD); enMotor4->setSpeed(speed); 
  }else if (_joy.Analog(BPSS_LX) > 130)
  {
    speed = map(_joy.Analog(BPSS_LX), 130, 255, 30, cur_speed);
    enMotor1->run(FORWARD); enMotor1->setSpeed(speed);
    enMotor2->run(BACKWARD); enMotor2->setSpeed(speed);
    enMotor3->run(BACKWARD); enMotor3->setSpeed(speed);
    enMotor4->run(FORWARD); enMotor4->setSpeed(speed);
  }

  //右侧摇杆控制车子前进后退 + 左右旋转
  if (_joy.Analog(BPSS_RY) < 125)
  {
    speed = map(_joy.Analog(BPSS_RY), 125, 0, 30, cur_speed);
    enMotor1->run(FORWARD); enMotor1->setSpeed(speed);
    enMotor2->run(FORWARD); enMotor2->setSpeed(speed);
    enMotor3->run(FORWARD); enMotor3->setSpeed(speed);
    enMotor4->run(FORWARD); enMotor4->setSpeed(speed);
    Serial.printf("up:%d,%d\n", _joy.Analog(BPSS_RY), speed);
  }else if (_joy.Analog(BPSS_RY) > 130)
  {
    speed = map(_joy.Analog(BPSS_RY), 130, 255, 30, cur_speed);   
    enMotor1->run(BACKWARD); enMotor1->setSpeed(speed);
    enMotor2->run(BACKWARD); enMotor2->setSpeed(speed);
    enMotor3->run(BACKWARD); enMotor3->setSpeed(speed);
    enMotor4->run(BACKWARD); enMotor4->setSpeed(speed);
    Serial.printf("down:%d,%d\n", _joy.Analog(BPSS_RY), speed);
  }

  if (_joy.Analog(BPSS_RX) < 125)
  {
    speed = map(_joy.Analog(BPSS_RX), 125, 0, 30, cur_speed);
    enMotor1->run(BACKWARD); enMotor1->setSpeed(speed);
    enMotor2->run(FORWARD); enMotor2->setSpeed(speed);
    enMotor3->run(BACKWARD); enMotor3->setSpeed(speed);
    enMotor4->run(FORWARD); enMotor4->setSpeed(speed);
    Serial.printf("left:%d,%d\n", _joy.Analog(BPSS_RX),speed);
  }else if (_joy.Analog(BPSS_RX) > 130)
  {
    speed = -map(_joy.Analog(BPSS_RX), 130, 255, 30, cur_speed);
    enMotor1->run(FORWARD); enMotor1->setSpeed(speed);
    enMotor2->run(BACKWARD); enMotor2->setSpeed(speed);
    enMotor3->run(FORWARD); enMotor3->setSpeed(speed);
    enMotor4->run(BACKWARD); enMotor4->setSpeed(speed);
    Serial.printf("right:%d,%d\n", _joy.Analog(BPSS_RX),speed);
  }

  if(speed > 0)
    last_pstime = millis();

  if(millis() - last_pstime > 100) {    //当一定时间内没有收到任何操作信号，则停车
    stop(100);
  }
}
